#version 330
#extension GL_EXT_gpu_shader4 : enable
// Magnetic Field Lines #2Mod01.fsh  by  adasba

//https://www.shadertoy.com/view/WlcSz4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//I didn't make this. Credit to:
//https://gist.github.com/yiwenl/745bfea7f04c456e0101
vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

//I didn't make this either. Credit to:
//https://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


const int pointCount = 32;
    
#define PI 3.1415926535897932384626433832795
    
vec2 magneticField(vec3[pointCount] pts, vec2 position) {
    vec2 netForce = vec2(0, 0);
    for (int i = 0; pointCount > i; i++) {
    	netForce += (position - pts[i].xy) / pow(distance(position, pts[i].xy), 3.0) * pts[i].z;
    }
    return netForce;
}

float modsign(float a, float b) {
	return mod(a, b) * sign(a);
}

vec3 points[pointCount];

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    vec2 m = vec2(iMouse.x / iResolution.x, iMouse.y / iResolution.y);
    
    for (int i = 0; pointCount > i; i++) {
        int pc = pointCount;
    	points[i] = vec3(0.0);
        points[i].x = rand(vec2(i, i + pc)) + sin(iTime * rand(vec2(i + pc * 5, i + pc * 6)) * 0.25) * 0.6;
        points[i].y = rand(vec2(i + pc * 2, i + pc * 3)) + sin(iTime * rand(vec2(i + pc * 7, i + pc * 8)) * 0.25) * 0.6;
        points[i].z = rand(vec2(i + pc * 4)) * 2.0 - 1.0;
    }
    
    points[1].x = m.x;
    points[1].y = m.y;
    points[1].z = -1.0;
    
    //points[0] = vec3(0.25, 0.25, 1.0);
    
    //points[2] = vec3(0.75, 0.75, 1.0);
	//points[1] = vec3(m.x, m.y, -1.0);
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;

    // Time varying pixel color
    //vec3 col = 0.5 + 0.5*cos(iTime+uv.xyx+vec3(0,2,4));

    // Output to screen
    //gl_FragColor = vec4(col,1.0);
    
    vec2 mField = magneticField(points, uv);
    float fieldMag = distance(vec2(0, 0), mField);
    float fieldDir = atan(mField.y, mField.x);
    //gl_FragColor = vec4(log(fieldMag * 5.2) * 0.2, fieldDir / (2.0 * PI) + 0.5, 0.0, 1.0);
    vec2 mField2 = magneticField(points, uv + vec2(0.005));
    vec2 mDeriv = mField - mField2;
    
    float logmag2 = log(distance(vec2(0), mField2)) * 5.0;
    
    //gl_FragColor = vec4(hsv2rgb(vec3(fieldDir / (PI * 2.0), 1.0, log(fieldMag * 20.0) * 0.1)), 1.0);
    float logmag = log(fieldMag) * 5.0;
    //float threshold = pow(distance(vec2(0.0), mDeriv), 0.33);
    //float col = (mod(5.0 * logmag, 2.0) > threshold) ? 0.0 : 1.0;
    float col = (abs(mod(logmag, 2.0) - mod(logmag2, 2.0)) > 1.0) ? 1.0 : 0.0;
    gl_FragColor = vec4(hsv2rgb(vec3(fieldDir / (PI * 2.0), 1.0, col)), 1.0);
}